-- Add PIX key columns to referral_codes table
ALTER TABLE public.referral_codes 
ADD COLUMN IF NOT EXISTS pix_key text,
ADD COLUMN IF NOT EXISTS pix_key_type text;

-- Create index for PIX key lookups
CREATE INDEX IF NOT EXISTS idx_referral_codes_pix_key ON public.referral_codes USING btree (pix_key);

-- Add comment
COMMENT ON COLUMN public.referral_codes.pix_key IS 'Chave PIX do indicador para recebimento da premiação';
COMMENT ON COLUMN public.referral_codes.pix_key_type IS 'Tipo da chave PIX: email, cpf, telefone ou aleatoria';
