"use client"

import { Instagram, Facebook, Youtube, Menu, X } from "lucide-react"
import Link from "next/link"
import { useEffect, useState } from "react"
import { createClient } from "@/lib/supabase/client"

export function TopBar() {
  const [menuOpen, setMenuOpen] = useState(false)

  const [socialLinks, setSocialLinks] = useState({
    instagram: "https://www.instagram.com/souunipora/",
    facebook: "https://www.facebook.com/Centrouniversitariodeipora/?locale=pt_BR",
    youtube: "https://www.youtube.com/@unipora?themeRefresh=1",
  })

  useEffect(() => {
    loadSocialLinks()
  }, [])

  const loadSocialLinks = async () => {
    const supabase = createClient()
    const { data } = await supabase
      .from("site_settings")
      .select("*")
      .in("key", ["instagram_url", "facebook_url", "youtube_url"])

    if (data) {
      const links: any = {}
      data.forEach((item) => {
        if (item.key === "instagram_url") links.instagram = item.value
        if (item.key === "facebook_url") links.facebook = item.value
        if (item.key === "youtube_url") links.youtube = item.value
      })
      setSocialLinks((prev) => ({ ...prev, ...links }))
    }
  }

  const topLinks = [
    { label: "DISCENTE", href: "https://fai.paineldoaluno.com.br/" },
    { label: "DOCENTE", href: "https://fai.paineldoaluno.com.br/professor_login" },
    { label: "NEAD", href: "/nead" },
    { label: "CENTRAL DE ATENDIMENTO", href: "/central-atendimento" },
    { label: "EGRESSO", href: "/matricula" },
    { label: "REVISTA", href: "https://revista.unipora.edu.br/index.php/ies" },
    { label: "OUVIDORIA", href: "/ouvidoria" },
    { label: "GALERIA", href: "/institucional#galeria" },
    { label: "PARCEIROS", href: "/parceiros" },
    { label: "RÁDIO/TV", href: "https://zeno.fm/radio/estacao-unipora/" },
  ]

  return (
    <div className="fixed top-0 left-0 right-0 z-50 bg-[#004488] text-white">
      <div className="container mx-auto px-4 relative">
        <div className="flex items-center justify-between h-10 px-4 mr-5 lg:mr-0">

          {/* Social Media Icons */}
          <div className="flex items-center gap-4">
            <Link href={socialLinks.instagram} target="_blank">
              <Instagram className="h-4 w-4" />
            </Link>
            <Link href={socialLinks.facebook} target="_blank">
              <Facebook className="h-4 w-4" />
            </Link>
            <Link href={socialLinks.youtube} target="_blank">
              <Youtube className="h-4 w-4" />
            </Link>
          </div>

          {/* Desktop Menu */}
          <nav className="hidden lg:flex items-center gap-6 mr-8">
            {topLinks.map((link) => (
              <Link
                key={link.href}
                href={link.href}
                className="text-xs font-medium hover:opacity-80 whitespace-nowrap"
              >
                {link.label}
              </Link>
            ))}
          </nav>

          {/* Mobile Hamburger */}
          <button
            onClick={() => setMenuOpen(!menuOpen)}
            className="lg:hidden text-white"
            aria-label="Abrir menu"
          >
            {menuOpen ? <X className="h-5 w-5" /> : <Menu className="h-5 w-5 mr-0" />}
          </button>
        </div>

        {/* Mobile Menu Dropdown */}
        {menuOpen && (
          <div className="absolute right-4 top-10 text-black rounded-lg w-64 p-4 flex flex-col gap-3 lg:hidden bg-background border-border shadow-md mt-3">
            {topLinks.map((link) => (
              <Link
                key={link.href}
                href={link.href}
                onClick={() => setMenuOpen(false)}
                className="hover:text-emerald-600 text-foreground font-extralight text-xs font-sans"
              >
                {link.label}
              </Link>
            ))}
          </div>
        )}
      </div>
    </div>
  )
}
