import { Button } from "@/components/ui/button"
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card"
import { Calendar, CreditCard, FileCheck, Clock } from "lucide-react"
import Link from "next/link"

export function ReenrollmentSection() {
  return (
    <section id="rematriculas" className="py-20 bg-background">
      <div className="container mx-auto px-4">
        <div className="max-w-4xl mx-auto">
          <div className="text-center mb-12">
            <Calendar className="h-12 w-12 text-primary mx-auto mb-4" />
            <h2 className="text-3xl md:text-4xl font-bold mb-4">Rematrículas 2026/1</h2>
            <p className="text-lg text-muted-foreground">Processo de rematrícula para alunos veteranos</p>
          </div>

          <Card className="mb-8 border-primary">
            <CardHeader className="bg-primary/5">
              <CardTitle>Período de Rematrículas</CardTitle>
              <CardDescription>Não perca o prazo para garantir sua vaga no próximo semestre</CardDescription>
            </CardHeader>
            <CardContent className="pt-6">
              <div className="flex items-center gap-2 text-lg font-semibold mb-2">
                <Clock className="h-5 w-5 text-primary" />
                <span>15 de Janeiro a 15 de Fevereiro de 2026</span>
              </div>
              <p className="text-sm text-muted-foreground">
                Realize sua rematrícula online de forma rápida e segura através do nosso portal.
              </p>
            </CardContent>
          </Card>

          <div className="grid md:grid-cols-3 gap-6 mb-8">
            <Card>
              <CardHeader>
                <FileCheck className="h-8 w-8 text-primary mb-2" />
                <CardTitle>1. Documentação</CardTitle>
              </CardHeader>
              <CardContent>
                <p className="text-sm text-muted-foreground">
                  Verifique se sua documentação está em dia no sistema acadêmico.
                </p>
              </CardContent>
            </Card>

            <Card>
              <CardHeader>
                <CreditCard className="h-8 w-8 text-primary mb-2" />
                <CardTitle>2. Pagamento</CardTitle>
              </CardHeader>
              <CardContent>
                <p className="text-sm text-muted-foreground">
                  Regularize possíveis pendências financeiras para liberar a rematrícula.
                </p>
              </CardContent>
            </Card>

            <Card>
              <CardHeader>
                <Calendar className="h-8 w-8 text-primary mb-2" />
                <CardTitle>3. Confirmação</CardTitle>
              </CardHeader>
              <CardContent>
                <p className="text-sm text-muted-foreground">
                  Acesse o portal e confirme sua rematrícula para o próximo período.
                </p>
              </CardContent>
            </Card>
          </div>

          <div className="text-center space-y-4">
            <Button size="lg" asChild>
              <Link href="/#rematricula">Fazer Rematrícula Online</Link>
            </Button>
            <p className="text-sm text-muted-foreground">Dúvidas? Entre em contato com a secretaria acadêmica</p>
          </div>
        </div>
      </div>
    </section>
  )
}
