import { Scale, FileText, Users } from "lucide-react"
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card"

export function ConsuSection() {
  return (
    <section id="consu" className="py-20 bg-muted/30">
      <div className="container mx-auto px-4">
        <div className="max-w-4xl mx-auto">
          <div className="text-center mb-12">
            <Scale className="h-12 w-12 text-primary mx-auto mb-4" />
            <h2 className="text-3xl md:text-4xl font-bold mb-4">CONSU Uniporá</h2>
            <p className="text-lg text-muted-foreground">Conselho Superior Universitário</p>
          </div>

          <div className="prose prose-lg max-w-none mb-8">
            <p className="text-muted-foreground leading-relaxed">
              O Conselho Superior Universitário (CONSU) é o órgão máximo de deliberação da Uniporá, responsável por
              definir as políticas gerais da instituição, aprovar projetos pedagógicos e zelar pela qualidade do ensino
              oferecido.
            </p>
          </div>

          <div className="grid md:grid-cols-3 gap-6">
            <Card>
              <CardHeader>
                <FileText className="h-8 w-8 text-primary mb-2" />
                <CardTitle>Regimento</CardTitle>
                <CardDescription>Normas e diretrizes do CONSU</CardDescription>
              </CardHeader>
              <CardContent>
                <p className="text-sm text-muted-foreground">
                  Acesse o regimento interno e conheça as atribuições e funcionamento do Conselho.
                </p>
              </CardContent>
            </Card>

            <Card>
              <CardHeader>
                <Users className="h-8 w-8 text-primary mb-2" />
                <CardTitle>Composição</CardTitle>
                <CardDescription>Membros do conselho</CardDescription>
              </CardHeader>
              <CardContent>
                <p className="text-sm text-muted-foreground">
                  Conheça os membros que compõem o Conselho Superior Universitário.
                </p>
              </CardContent>
            </Card>

            <Card>
              <CardHeader>
                <FileText className="h-8 w-8 text-primary mb-2" />
                <CardTitle>Resoluções</CardTitle>
                <CardDescription>Deliberações e decisões</CardDescription>
              </CardHeader>
              <CardContent>
                <p className="text-sm text-muted-foreground">Acesse as resoluções e decisões tomadas pelo CONSU.</p>
              </CardContent>
            </Card>
          </div>
        </div>
      </div>
    </section>
  )
}
