import { Building2, Users, Award, BookOpen } from "lucide-react"

export function AboutSection() {
  const stats = [
    { icon: Building2, value: "20+", label: "Anos de História" },
    { icon: Users, value: "5.000+", label: "Alunos Formados" },
    { icon: Award, value: "30+", label: "Cursos Oferecidos" },
    { icon: BookOpen, value: "100+", label: "Professores Qualificados" },
  ]

  return (
    <section id="sobre" className="py-20 bg-background">
      <div className="container mx-auto px-4">
        <div className="max-w-4xl mx-auto">
          <h1 className="text-4xl md:text-5xl font-bold text-center mb-6">Sobre a Uniporá</h1>
          <p className="text-lg text-muted-foreground text-center mb-12 leading-relaxed">
            Centro Universitário de Iporá
          </p>

          <div className="prose prose-lg max-w-none mb-16">
            <p className="text-muted-foreground leading-relaxed">
              A Uniporá é uma instituição de ensino superior comprometida com a excelência acadêmica e o desenvolvimento
              regional. Localizada em Iporá, Goiás, nossa missão é formar profissionais qualificados e cidadãos
              conscientes, preparados para os desafios do mercado de trabalho e comprometidos com o desenvolvimento
              social.
            </p>
            <p className="text-muted-foreground leading-relaxed">
              Com uma infraestrutura moderna e corpo docente altamente qualificado, oferecemos cursos de graduação,
              pós-graduação e técnicos nas mais diversas áreas do conhecimento. Nossa proposta pedagógica alia teoria e
              prática, preparando nossos alunos para se destacarem em suas carreiras profissionais.
            </p>
            <p className="text-muted-foreground leading-relaxed">
              Acreditamos que a educação é o caminho para transformar vidas e contribuir para o desenvolvimento da
              sociedade. Por isso, investimos constantemente em inovação, tecnologia e metodologias de ensino que
              proporcionem aos nossos alunos uma formação completa e diferenciada.
            </p>
          </div>

          <div className="grid grid-cols-2 md:grid-cols-4 gap-8">
            {stats.map((stat, index) => (
              <div key={index} className="text-center">
                <div className="flex justify-center mb-4">
                  <div className="w-16 h-16 rounded-full bg-primary/10 flex items-center justify-center">
                    <stat.icon className="h-8 w-8 text-primary" />
                  </div>
                </div>
                <div className="text-3xl font-bold mb-2">{stat.value}</div>
                <div className="text-sm text-muted-foreground">{stat.label}</div>
              </div>
            ))}
          </div>
        </div>
      </div>
    </section>
  )
}
