"use client"

import { useState, useEffect } from "react"
import { Button } from "@/components/ui/button"
import { Menu, X } from "lucide-react"
import Link from "next/link"
import Image from "next/image"
import { ReferralModal } from "@/components/referral-modal"

export function Header() {
  const [isScrolled, setIsScrolled] = useState(false)
  const [isMobileMenuOpen, setIsMobileMenuOpen] = useState(false)

  const [isDark, setIsDark] = useState(false)

  useEffect(() => {
    const handleScroll = () => {
      setIsScrolled(window.scrollY > 10)
    }
    window.addEventListener("scroll", handleScroll)
    return () => window.removeEventListener("scroll", handleScroll)
  }, [])

  const menuItems = [
    { label: "Início", href: "/" },
    { label: "Institucional", href: "/institucional" },
    { label: "Cursos", href: "/cursos" },
    { label: "Ingresso", href: "/matricula" },
    { label: "Contato", href: "/contato" },
    {
      label: "UNISA",
      href: "https://www.unisa.br/?gclid=Cj0KCQjwn9CgBhDjARIsAD15h0Dh9cs9G595VLoXbRTKCkO9-rGh2_BKiuPuy0FwjsO0aqBYkWTz464aAgarEALw_wcB",
    },
  ]

  return (
    <header
      className={`fixed top-10 left-0 right-0 z-40 transition-all duration-300 ${
        isScrolled ? "bg-background/20 backdrop-blur shadow-md" : "bg-white"
      }`}
    >
      <div className="container mx-auto px-4">
        <div className="flex items-center justify-between h-20 text-white">
          <Link href="/" className="flex items-center">
            <Image src="/images/whitelogo.png" alt="Uniporá" width={180} height={50} className="h-10 w-auto" priority />
          </Link>

          {/* Desktop Menu */}
          <nav className="hidden lg:flex items-center gap-8">
            {menuItems.map((item) => (
              <Link
                key={item.href}
                href={item.href}
                className={`text-sm font-light transition-colors hover:text-primary text-slate-500 border border-t-0 border-l-0 border-r-0 px-0 border-b-0 ${
                  isScrolled ? "text-black dark:text-white" : "text-black dark:text-black"
                }`}
              >
                {item.label}
              </Link>
            ))}
          </nav>

          <div className="hidden lg:flex items-center gap-3">
            <ReferralModal />
            <Button
              className={`font-light border-[rgba(120,120,120,0.278)] transition-colors duration-300 ease-in-out
                ${
                  isScrolled
                    ? "bg-white text-primary dark:bg-gray-800 dark:text-white hover:text-blue-300"
                    : "bg-white text-primary dark:bg-gray-800 dark:text-white hover:text-blue-300"
                }`}
              variant="outline"
              asChild
            >
              <Link href="/matricula">Inscreva-se</Link>
            </Button>
          </div>

          {/* Mobile Menu Button */}
          <button
            className="lg:hidden p-2"
            onClick={() => setIsMobileMenuOpen(!isMobileMenuOpen)}
            aria-label="Toggle menu"
          >
            {isMobileMenuOpen ? (
              <X className="h-6 w-6 dark:text-blue-500 text-red-600" />
            ) : (
              <Menu className="h-6 w-6 text-blue-500 dark:text-blue-500" />
            )}
          </button>
        </div>

        {/* Mobile Menu */}
        {isMobileMenuOpen && (
          <div className="lg:hidden py-6 border-t animate-in fade-in slide-in-from-top-2 duration-200">
            <nav className="flex flex-col gap-4">
              {menuItems.map((item) => (
                <Link
                  key={item.href}
                  href={item.href}
                  className="text-sm font-medium hover:text-foreground transition-colors py-2 text-gray-500"
                  onClick={() => setIsMobileMenuOpen(false)}
                >
                  {item.label}
                </Link>
              ))}
              <div className="py-2">
                <ReferralModal />
              </div>
              <div className="flex flex-col gap-3 pt-4 border-t">
                <Button asChild className="w-full">
                  <Link href="/matricula">Inscreva-se</Link>
                </Button>
              </div>
            </nav>
          </div>
        )}
      </div>
    </header>
  )
}
