"use client"

import { UserIcon } from "lucide-react"
import Link from "next/link"

export function AdminLoginButton() {
  return (
    <Link
      href="/auth/login"
      className="fixed top-2 right-4 z-[60] p-2 rounded-full bg-gray-200 dark:bg-gray-800 hover:bg-gray-300 dark:hover:bg-gray-700 transition-colors opacity-20 hover:opacity-100 px-1 py-1"
      title="Login Administrativo"
    >
      <UserIcon className="h-4 w-4 text-gray-600 dark:text-gray-400" />
    </Link>
  )
}
