"use client"

import { useState } from "react"
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs"
import { Button } from "@/components/ui/button"
import {
  LogOut,
  GraduationCap,
  ImageIcon,
  Settings,
  UserCheck,
  Tag,
  Users,
  Briefcase,
  Image
} from "lucide-react"

import { createClient } from "@/lib/supabase/client"
import { useRouter } from "next/navigation"
import { CoursesManager } from "./admin/courses-manager"
import { HeroSlidesManager } from "./admin/hero-slides-manager"
import { SettingsManager } from "./admin/settings-manager"
import { EnrollmentsManager } from "./admin/enrollments-manager"
import { ReferralsManager } from "./admin/referrals-manager"
import { JobApplicationsManager } from "./admin/job-applications-manager"
import { GalleryManager } from "./admin/gallery-manager"
import { ReferralCodesManager } from "./admin/referral-codes-manager"

interface AdminDashboardProps {
  user: {
    email?: string
  }
}

export function AdminDashboard({ user }: AdminDashboardProps) {
  const router = useRouter()
  const [isLoggingOut, setIsLoggingOut] = useState(false)

  const handleLogout = async () => {
    setIsLoggingOut(true)
    const supabase = createClient()
    await supabase.auth.signOut()
    router.push("/")
  }

  return (
    <div className="min-h-screen bg-background">
      {/* Header */}
      <div className="border-b bg-card">
        <div className="container mx-auto px-4 py-4 flex items-center justify-between">
          <div>
            <h1 className="text-2xl font-bold">Painel Administrativo</h1>
            <p className="text-sm text-muted-foreground">Bem-vindo, {user.email}</p>
          </div>
          <Button variant="outline" onClick={handleLogout} disabled={isLoggingOut}>
            <LogOut className="h-4 w-4 mr-2" />
            {isLoggingOut ? "Saindo..." : "Sair"}
          </Button>
        </div>
      </div>

      {/* Main Content */}
      <div className="container mx-auto px-4 py-8">
      <Tabs defaultValue="enrollments" className="space-y-6">

  {/* TABS */}
  <TabsList
  className="
    flex w-full gap-2
    overflow-x-auto
    whitespace-nowrap
    scrollbar-thin
  "
>

    <TabsTrigger value="enrollments" className="flex items-center gap-2 flex-shrink-0">
      <UserCheck className="h-4 w-4" />
      <span className="hidden sm:inline">Matrículas</span>
    </TabsTrigger>

    <TabsTrigger value="referral-codes" className="flex items-center gap-2 flex-shrink-0">
      <Tag className="h-4 w-4" />
      <span className="hidden sm:inline">Códigos</span>
    </TabsTrigger>

    <TabsTrigger value="courses" className="flex items-center gap-2 flex-shrink-0">
      <GraduationCap className="h-4 w-4" />
      <span className="hidden sm:inline">Cursos</span>
    </TabsTrigger>

    <TabsTrigger value="hero" className="flex items-center gap-2 flex-shrink-0">
      <ImageIcon className="h-4 w-4" />
      <span className="hidden sm:inline">Hero Slides</span>
    </TabsTrigger>

    <TabsTrigger value="settings" className="flex items-center gap-2 flex-shrink-0">
      <Settings className="h-4 w-4" />
      <span className="hidden sm:inline">Configurações</span>
    </TabsTrigger>

    <TabsTrigger value="referrals" className="flex items-center gap-2 flex-shrink-0">
  <Users className="h-4 w-4" />
  <span className="hidden sm:inline">Indicações</span>
</TabsTrigger>

<TabsTrigger value="jobs" className="flex items-center gap-2 flex-shrink-0">
  <Briefcase className="h-4 w-4" />
  <span className="hidden sm:inline">Candidaturas</span>
</TabsTrigger>

<TabsTrigger value="gallery" className="flex items-center gap-2 flex-shrink-0">
  <Image className="h-4 w-4" />
  <span className="hidden sm:inline">Galeria</span>
</TabsTrigger>

  </TabsList>

  {/* CONTEÚDOS */}
  <TabsContent value="enrollments">
    <EnrollmentsManager />
  </TabsContent>

  <TabsContent value="referral-codes">
    <ReferralCodesManager />
  </TabsContent>

  <TabsContent value="courses">
    <CoursesManager />
  </TabsContent>

  <TabsContent value="hero">
    <HeroSlidesManager />
  </TabsContent>

  <TabsContent value="settings">
    <SettingsManager />
  </TabsContent>

  <TabsContent value="referrals">
    <ReferralsManager />
  </TabsContent>

  <TabsContent value="jobs">
    <JobApplicationsManager />
  </TabsContent>

  <TabsContent value="gallery">
    <GalleryManager />
  </TabsContent>

</Tabs>



      </div>
    </div>
  )
}
