export function AboutSection() {
  return (
    <section id="sobre" className="bg-card py-16">
      <div className="container mx-auto px-4">
        <div className="max-w-4xl mx-auto text-center">
          <h2 className="text-4xl md:text-5xl font-bold mb-6 text-balance">Centro Universitário de Iporá</h2>
          <p className="text-xl text-muted-foreground mb-8 leading-relaxed text-pretty">
            A Uniporá é referência em educação superior em Goiás, comprometida em formar profissionais qualificados e
            preparados para os desafios do mercado de trabalho.
          </p>
          <div className="grid md:grid-cols-3 gap-8 mt-16">
            <div className="p-6">
              <div className="text-6xl font-bold text-primary mb-4">Missão</div>
              <p className="text-muted-foreground leading-relaxed">
                Promover educação de qualidade, formando cidadãos críticos e profissionais competentes para transformar
                a sociedade.
              </p>
            </div>
            <div className="p-6">
              <div className="text-6xl font-bold text-primary mb-4">Visão</div>
              <p className="text-muted-foreground leading-relaxed">
                Ser reconhecida como a melhor instituição de ensino superior da região, referência em inovação e
                excelência acadêmica.
              </p>
            </div>
            <div className="p-6">
              <div className="text-6xl font-bold text-primary mb-4">Valores</div>
              <p className="text-muted-foreground leading-relaxed">
                Ética, responsabilidade social, inovação, qualidade no ensino e compromisso com o desenvolvimento
                regional.
              </p>
            </div>
          </div>
        </div>
      </div>
    </section>
  )
}
