import { TopBar } from "@/components/top-bar"
import { Header } from "@/components/header"
import { Footer } from "@/components/footer"
import { EnrollmentHero } from "@/components/enrollment-hero"
import { EnrollmentStepper } from "@/components/enrollment-stepper"
import { Suspense } from "react"

export default function MatriculaPage() {
  return (
    <main className="min-h-screen">
      <TopBar />
      <Header />
      <EnrollmentHero />
      <Suspense
        fallback={
          <section className="py-16 bg-background">
            <div className="container mx-auto px-4">
              <div className="max-w-4xl mx-auto text-center">
                <p className="text-muted-foreground">Carregando formulário...</p>
              </div>
            </div>
          </section>
        }
      >
        <EnrollmentStepper />
      </Suspense>
      <Footer />
    </main>
  )
}
