import type { Metadata } from "next"
import { Geist, Geist_Mono } from "next/font/google"
import { Analytics } from "@vercel/analytics/next"

import "./globals.css"

import { ThemeToggleFab } from "@/components/theme-toggle-fab"
import { AdminLoginButton } from "@/components/admin-login-button"
import { RadioPlayerFab } from "@/components/radio-player-fab"

const geist = Geist({ subsets: ["latin"] })
const geistMono = Geist_Mono({ subsets: ["latin"] })

export const metadata: Metadata = {
  title: "Uniporá - Centro Universitário de Iporá",
  description:
    "Construa sua carreira com a Uniporá. Cursos de graduação, pós-graduação e tecnólogos em Iporá, Goiás.",
  generator: "v0.app",
}

export default function RootLayout({
  children,
}: {
  children: React.ReactNode
}) {
  return (
    <html lang="pt-BR">
      <body className="font-sans antialiased">
        {children}


        {/* FABs */}
        <RadioPlayerFab />
        <ThemeToggleFab />
        <AdminLoginButton />

        <Analytics />
      </body>
    </html>
  )
}
