"use client"

import { useEffect } from "react"
import { TopBar } from "@/components/top-bar"
import { Header } from "@/components/header"
import { Footer } from "@/components/footer"
import { AboutSection } from "@/components/institutional/about-section"
import { ReferFriendsSection } from "@/components/institutional/refer-friends-section"
import { GallerySection } from "@/components/institutional/gallery-section"
import { ConsuSection } from "@/components/institutional/consu-section"
import { LgpdSection } from "@/components/institutional/lgpd-section"
import { CareersSection } from "@/components/institutional/careers-section"
import { ReenrollmentSection } from "@/components/institutional/reenrollment-section"

export default function InstitutionalPage() {
  useEffect(() => {
    // Check if there's a hash in the URL
    const hash = window.location.hash
    if (hash) {
      // Wait for page to load completely
      setTimeout(() => {
        const element = document.querySelector(hash)
        if (element) {
          // Calculate offset for fixed header (TopBar + Header = ~120px)
          const offset = 120
          const elementPosition = element.getBoundingClientRect().top
          const offsetPosition = elementPosition + window.pageYOffset - offset

          window.scrollTo({
            top: offsetPosition,
            behavior: "smooth",
          })
        }
      }, 100)
    }
  }, [])

  return (
    <div className="min-h-screen">
      <TopBar />
      <Header />
      <main className="pt-32">
        <AboutSection />
        <ReferFriendsSection />
        <GallerySection />
        <ConsuSection />
        <LgpdSection />
        <CareersSection />
        <ReenrollmentSection />
      </main>
      <Footer />
    </div>
  )
}
